/*Codice SAS per riprodurre il grafico in figura 42*/

ods html close; 
ods html;
proc iml;

N=100;
pd=0.4; 
p0=pd;

LB= (pd-1)/pd;
if pd<0.5 then LB=1/LB;
print LB;
epsilon1 = 0.01/2;
LB = LB+epsilon1;
print LB;

/* Salviamo questi valori in macrovariabili */
CALL SYMPUTX("N", N);
CALL SYMPUTX("PD", pd);

free allpdf params; /*inizializzazione della matrice allpdf*/
do ro= LB to 0.99 by .05; /*creo un grande ciclo che itera in base a rho, poich alpha e beta dipendono da q che a sua volta dipende da rho. Quindi in base alla correlazione rho tra i default si avr una distribuzione di probabilit diversa*/
	I=pd*(1-pd);
	L=p0*(1-p0);
	q=(sqrt(I)*sqrt(L)*ro)+(pd*p0); 
	D=(pd-q)/(1-p0-pd+q);
	E=(q/(p0-q))*((1-p0-pd+q)/(pd-q));
	F=(1-p0)/p0;
	G=(p0-q)/(1-p0-pd+q);
             alpha=log(D);
	alphazero=((N-1)*log(F))+(N*log(G));
	beta= log(E);
	params=params//(ro||alpha||alphazero||beta);
	H=alpha+beta;
	*print H;
	Z=((1+exp(alpha))##N) + ( exp(alphazero)*(1+exp(H))##N );

	somma_pdf=j(N+1,3,.);
	do ll=0 to N;
		coeff_bin= comb(N, ll);
		A= 1/Z;
		B= alpha * ll;
		C= alphazero + (ll*(alpha + beta));
		exp_B = exp(B);
		exp_C = exp(C);
		somma_pdf[ll+1,1]=ll; /* ll+1,  per iniziare dalla riga 1, perch la 0 non esiste*/
		somma_pdf[ll+1,2] = A * coeff_bin * (exp_B + exp_C); /* Calcola la densit di probabilit DISCRETA PMF*/
		somma_pdf[ll+1,3]=ro;
	end;
	allpdf=allpdf//somma_pdf; /*appende due matrici una sotto l'altra per le varie correlazioni*/

end; /*end del ciclo rho*/

lossNorm=allpdf[,1]/N*100; /* normalizzazione del valore sull'asse x*/
allpdf=allpdf||lossNorm; /* accosta i due vettori colonna per colonna*/
create plt_pdf from allpdf[colname={"somma" "pdf" "rho" "lossnorm"}]; /* Creazione del dataset con i nomi delle colonne */
    
    /* Aggiunta di una riga al dataset */
    append from allpdf; /* Appendiamo una riga con i valori di som e ff */
    close plt_pdf; /* Chiusura del dataset */
    create params from params[colname={"rho" "alpha" "alphazero" "beta"}];
    append from params; /* Appendiamo una riga con i valori di som e ff */
    close params; /* Chiusura del dataset */
quit;

/* Codice per il grafico */
proc sgplot data=plt_pdf(where=(abs(rho-(-0.262))<1E-2 | abs(rho-(0.2883))<1E-2));
series x=lossnorm y=pdf / group=rho lineattrs=(thickness=2); /* Traccia il grafico a LINEE*/
	
xaxis label = "Loss %";
yaxis label = "Loss probability";

run;
